/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.List;
import java.util.Vector;
import test.TestThreadPDFGenerator;

public class TestThreadPDFGeneratorQueueManager {
    static int s_counterMax = 2;
    static int s_counter = 0;
    static List<TestThreadPDFGeneratorQueueManager> s_waitingQMs = new Vector<TestThreadPDFGeneratorQueueManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePDF(String name) {
        TestThreadPDFGeneratorQueueManager testThreadPDFGeneratorQueueManager = this;
        synchronized (testThreadPDFGeneratorQueueManager) {
            try {
                if (s_counter > s_counterMax - 1) {
                    System.out.println(name + " - Too many threads, waiting!");
                    try {
                        s_waitingQMs.add(this);
                        this.wait();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    System.out.println(name + "Now continuing...");
                } else {
                    ++s_counter;
                }
                TestThreadPDFGenerator.generatePDF(name);
            }
            finally {
                --s_counter;
                this.processWaitingQMs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupNow() {
        TestThreadPDFGeneratorQueueManager testThreadPDFGeneratorQueueManager = this;
        synchronized (testThreadPDFGeneratorQueueManager) {
            this.notify();
        }
    }

    private synchronized void processWaitingQMs() {
        while (s_waitingQMs.size() > 0 && s_counter < s_counterMax) {
            TestThreadPDFGeneratorQueueManager firstQM = s_waitingQMs.get(0);
            s_waitingQMs.remove(0);
            ++s_counter;
            firstQM.wakeupNow();
        }
    }
}

