/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.dyndata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.dyndata.util.AttributeTextResolver;
import org.eclnt.ccaddons.pbc.dyndata.util.UtilDynDataView;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.text.CCEditText;
import org.eclnt.ccaddons.pbc.text.CCShowText;
import org.eclnt.ccee.db.jdbc.JDBCTableInfo;
import org.eclnt.ccee.db.jdbc.JDBCUtils;
import org.eclnt.ccee.dyndata.DynDataAttribute;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.dyndata.meta.ENUMFileReadingType;
import org.eclnt.ccee.dyndata.meta.ENUMPropertyFileReadingType;
import org.eclnt.ccee.dyndata.properties.PropertyAccess;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Clipboard;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlush;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.util.ValidValuesBinding;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCDynDataDetail}")
public class CCDynDataDetail
extends PageBeanComponent
implements Serializable {
    private IListener m_listener;
    private DynDataDefinition m_ddd;
    FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding();
    ValidValuesBinding m_propertyFileReadingTypeVVS = new ValidValuesBinding();
    ValidValuesBinding m_xmlFileReadingTypeVVS = new ValidValuesBinding();
    DynDataReaderContext m_ddrContext;
    String m_searchText;

    public CCDynDataDetail() {
        this.m_propertyFileReadingTypeVVS.addValidValue(ENUMPropertyFileReadingType.PROPERTYACCESSINTERFACE.toString(), "By own persistence");
        this.m_propertyFileReadingTypeVVS.addValidValue(ENUMPropertyFileReadingType.STREAMSTORE.toString(), "By stream store");
        this.m_propertyFileReadingTypeVVS.addValidValue(ENUMPropertyFileReadingType.FILE.toString(), "By file system");
        this.m_propertyFileReadingTypeVVS.addValidValue(ENUMPropertyFileReadingType.RESOURCE.toString(), "By class loader");
        this.m_xmlFileReadingTypeVVS.addValidValue(ENUMFileReadingType.STREAMSTORE.toString(), "By stream store");
        this.m_xmlFileReadingTypeVVS.addValidValue(ENUMFileReadingType.FILE.toString(), "By file system");
        this.m_xmlFileReadingTypeVVS.addValidValue(ENUMFileReadingType.RESOURCE.toString(), "By class loader");
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCDynDataDetail}";
    }

    public void prepare(DynDataReaderContext ddrContext, DynDataDefinition ddd, IListener listener) {
        this.m_ddrContext = ddrContext;
        this.m_ddd = ddd;
        this.m_listener = listener;
        this.updatePropertyGrid();
    }

    public String getSearchText() {
        return this.m_searchText;
    }

    public void setSearchText(String value) {
        this.m_searchText = value;
    }

    public void onPropertyFilePathAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            IdTextSelection idts = IdTextSelection.createInstance();
            List ids = PropertyAccess.instance().readPropertyFileIds();
            for (String id : ids) {
                idts.addLine("API:" + id, "API:" + id);
            }
            List fpis = DynDataUtil.readAvailablePropertyFiles((DynDataReaderContext)this.m_ddrContext);
            for (DynDataUtil.FilePathInfo file : fpis) {
                idts.addLine(file.toIdString(), file.toIdString());
            }
            idts.setRenderIdColumn(false);
            idts.setCallBack(new ISetId(){

                public void setId(String id) {
                    if (id.startsWith("API:")) {
                        CCDynDataDetail.this.m_ddd.setPropertyFilePath(id.substring("API:".length()));
                        CCDynDataDetail.this.m_ddd.setPropertyFileReadingType(ENUMPropertyFileReadingType.PROPERTYACCESSINTERFACE);
                    } else {
                        DynDataUtil.FilePathInfo fpi = DynDataUtil.FilePathInfo.fromIdString((String)id);
                        CCDynDataDetail.this.m_ddd.setPropertyFilePath(fpi.getFilePath());
                        ENUMPropertyFileReadingType pfrt = ENUMPropertyFileReadingType.valueOf((String)fpi.getReadingType().toString());
                        CCDynDataDetail.this.m_ddd.setPropertyFileReadingType(pfrt);
                        CCDynDataDetail.this.updatePropertyGrid();
                    }
                    CCDynDataDetail.this.updatePropertyGrid();
                }
            });
        } else if (event instanceof BaseActionEventFlush) {
            this.updatePropertyGrid();
        }
    }

    public void onXmlFilePathAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            if (this.m_ddrContext.getXmlFileRootDirectory() != null) {
                IdTextSelection idts = IdTextSelection.createInstance();
                List fpis = DynDataUtil.readAvailableXMLFiles((DynDataReaderContext)this.m_ddrContext);
                for (DynDataUtil.FilePathInfo file : fpis) {
                    idts.addLine(file.toIdString(), file.toIdString());
                }
                idts.setRenderIdColumn(false);
                idts.setCallBack(new ISetId(){

                    public void setId(String id) {
                        DynDataUtil.FilePathInfo fpi = DynDataUtil.FilePathInfo.fromIdString((String)id);
                        CCDynDataDetail.this.m_ddd.setXmlFilePath(fpi.getFilePath());
                        CCDynDataDetail.this.m_ddd.setXmlFileReadingType(fpi.getReadingType());
                        CCDynDataDetail.this.updatePropertyGrid();
                    }
                });
            }
        } else if (event instanceof BaseActionEventFlush) {
            this.updatePropertyGrid();
        }
    }

    public void onJsonFilePathAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            if (this.m_ddrContext.getJsonFileRootDirectory() != null) {
                IdTextSelection idts = IdTextSelection.createInstance();
                List fpis = DynDataUtil.readAvailableJSONFiles((DynDataReaderContext)this.m_ddrContext);
                for (DynDataUtil.FilePathInfo file : fpis) {
                    idts.addLine(file.toIdString(), file.toIdString());
                }
                idts.setRenderIdColumn(false);
                idts.setCallBack(new ISetId(){

                    public void setId(String id) {
                        DynDataUtil.FilePathInfo fpi = DynDataUtil.FilePathInfo.fromIdString((String)id);
                        CCDynDataDetail.this.m_ddd.setJsonFilePath(fpi.getFilePath());
                        CCDynDataDetail.this.m_ddd.setJsonFileReadingType(fpi.getReadingType());
                        CCDynDataDetail.this.updatePropertyGrid();
                    }
                });
            }
        } else if (event instanceof BaseActionEventFlush) {
            this.updatePropertyGrid();
        }
    }

    public ValidValuesBinding getPropertyFileReadingTypeVVS() {
        return this.m_propertyFileReadingTypeVVS;
    }

    public ValidValuesBinding getXmlFileReadingTypeVVS() {
        return this.m_xmlFileReadingTypeVVS;
    }

    public DynDataDefinition getDdd() {
        return this.m_ddd;
    }

    public FIXGRIDListBinding<GridItem> getGrid() {
        return this.m_grid;
    }

    public void onEntityClassAction(ActionEvent event) {
        if (event instanceof BaseActionEventFlush) {
            this.updatePropertyGrid();
        }
    }

    public void onScriptAction(ActionEvent event) {
        this.updateVirtualAttributes();
    }

    public void onSearchTextAction(ActionEvent event) {
        this.updatePropertyGrid();
    }

    public void onTableNameAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            IdTextSelection idts = IdTextSelection.createInstance();
            List ts = JDBCUtils.findTables((String)this.findDbContextName());
            for (JDBCTableInfo t : ts) {
                idts.addLine(t.getName(), t.getName());
            }
            idts.setRenderFilterText(true);
            idts.setRenderIdColumn(false);
            idts.setCallBack(new ISetId(){

                public void setId(String id) {
                    CCDynDataDetail.this.m_ddd.setTableName(id);
                    CCDynDataDetail.this.updatePropertyGrid();
                }
            });
        } else if (event instanceof BaseActionEventFlush) {
            this.updatePropertyGrid();
        }
    }

    public boolean getAvailableFirstLevelOnly() {
        if (this.m_listener != null) {
            List<DynDataDefinition> parentDdds = this.m_listener.findParentDynDataDefinitions();
            return parentDdds.size() == 0;
        }
        return true;
    }

    public boolean getAvailableBelowFirstLevelOnly() {
        if (this.m_listener != null) {
            return !this.getAvailableFirstLevelOnly();
        }
        return true;
    }

    public boolean getAvailableProposeQuery() {
        return this.m_ddd.getClassName() != null;
    }

    public boolean getEnabledViewXML() {
        return this.m_ddd.getXmlFilePath() != null && this.m_ddd.getXmlFileReadingType() != null;
    }

    public boolean getEnabledEditXML() {
        return this.getEnabledViewXML() && this.m_ddd.getXmlFileReadingType() != ENUMFileReadingType.RESOURCE;
    }

    public boolean getEnabledViewJSON() {
        return this.m_ddd.getJsonFilePath() != null && this.m_ddd.getJsonFileReadingType() != null;
    }

    public boolean getEnabledEditJSON() {
        return this.getEnabledViewJSON() && this.m_ddd.getJsonFileReadingType() != ENUMFileReadingType.RESOURCE;
    }

    public boolean getEnabledViewProperties() {
        return this.m_ddd.getPropertyFilePath() != null && (this.m_ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.FILE || this.m_ddd.getPropertyFileReadingType() == ENUMPropertyFileReadingType.STREAMSTORE);
    }

    public boolean getEnabledEditProperties() {
        return this.getEnabledViewProperties();
    }

    public void onViewXMLAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readXmlFileOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCShowText.openPopupInstance((IPageBean)this, (String)this.m_ddd.getXmlFilePath(), (String)text);
    }

    public void onEditXMLAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readXmlFileOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCEditText.openAsPopup((IPageBean)this, (String)text, (CCEditText.IListener)new CCEditText.DefaultListener(){

            public void reactOnOK(String text) {
                DynDataUtil.saveXmlFileOfDynDataDefinition((DynDataReaderContext)CCDynDataDetail.this.m_ddrContext, (DynDataDefinition)CCDynDataDetail.this.m_ddd, (String)text, (boolean)true);
            }
        });
    }

    public void onViewJSONAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readJsonFileOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCShowText.openPopupInstance((IPageBean)this, (String)this.m_ddd.getJsonFilePath(), (String)text);
    }

    public void onEditJSONAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readJsonFileOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCEditText.openAsPopup((IPageBean)this, (String)text, (CCEditText.IListener)new CCEditText.DefaultListener(){

            public void reactOnOK(String text) {
                DynDataUtil.saveJsonFileOfDynDataDefinition((DynDataReaderContext)CCDynDataDetail.this.m_ddrContext, (DynDataDefinition)CCDynDataDetail.this.m_ddd, (String)text, (boolean)true);
            }
        });
    }

    public void onViewPropertiesAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readPropertyFileTextOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCShowText.openPopupInstance((IPageBean)this, (String)this.m_ddd.getPropertyFilePath(), (String)text);
    }

    public void onEditPropertiesAction(ActionEvent event) {
        String text = "";
        try {
            text = DynDataUtil.readPropertyFileTextOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CCEditText.openAsPopup((IPageBean)this, (String)text, (CCEditText.IListener)new CCEditText.DefaultListener(){

            public void reactOnOK(String text) {
                DynDataUtil.savePropertyFileOfDynDataDefinition((DynDataReaderContext)CCDynDataDetail.this.m_ddrContext, (DynDataDefinition)CCDynDataDetail.this.m_ddd, (String)text, (boolean)true);
            }
        });
    }

    public void onProposeQueryAction(ActionEvent event) {
        try {
            ArrayList<DynDataDefinition> parentDdds = new ArrayList();
            if (this.m_listener != null) {
                parentDdds = this.m_listener.findParentDynDataDefinitions();
            }
            String proposal = UtilDynDataView.instance().proposeDofwSql(this.m_ddd, parentDdds);
            this.m_ddd.setDofwQuery(proposal);
        }
        catch (Throwable t) {
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
        }
    }

    private void updatePropertyGrid() {
        this.m_grid.getItems().clear();
        try {
            List ddas = DynDataUtil.readAttributesOfDynDataDefinition((DynDataReaderContext)this.m_ddrContext, (DynDataDefinition)this.m_ddd, (boolean)false);
            for (DynDataAttribute dda : ddas) {
                GridItem gi = new GridItem();
                gi.setPropertyName(dda.getName());
                gi.setKey(dda.isKey());
                if (!ValueManager.isEmpty((String)this.m_searchText) && !ValueManager.checkIfStringContainsTokenizedSearchString((String)gi.getText(), (String)this.m_searchText)) continue;
                this.m_grid.getItems().add(gi);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updateVirtualAttributes() {
        this.m_ddd.getVirtualAttributes().clear();
        if (this.m_ddd.getScript() != null) {
            List vas = DynDataUtil.readVirtualAttributesFromJavaScript((String)this.m_ddd.getScript());
            this.m_ddd.getVirtualAttributes().addAll(vas);
        }
    }

    private String findDbContextName() {
        if (ValueManager.isEmpty((String)this.m_ddd.getDataContextName())) {
            return this.m_ddrContext.getDbContextName();
        }
        return this.m_ddd.getDataContextName();
    }

    public static interface IListener
    extends Serializable {
        public List<DynDataDefinition> findParentDynDataDefinitions();
    }

    public class GridItem
    extends FIXGRIDItem
    implements Serializable {
        String i_text;
        String i_propertyName;
        boolean i_isKey = false;

        public String getPropertyName() {
            return this.i_propertyName;
        }

        public void setPropertyName(String value) {
            this.i_propertyName = value;
            this.i_text = AttributeTextResolver.instance().resolveText(CCDynDataDetail.this.m_ddd, this.i_propertyName);
        }

        public String getText() {
            return this.i_text;
        }

        public boolean isKey() {
            return this.i_isKey;
        }

        public void setKey(boolean isKey) {
            this.i_isKey = isKey;
        }

        public String getFont() {
            if (this.i_isKey) {
                return "weight:bold";
            }
            return null;
        }

        public void onRowSelect() {
        }

        public void onRowExecute() {
        }

        public void onClipboardAction(ActionEvent event) {
            Clipboard.copyToClientClipboard((String)this.i_propertyName);
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgCopiedClipboard", this.i_propertyName));
        }
    }
}

