/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.CCMasterDetail;
import org.eclnt.ccaddons.pbc.dyndata.preview.DynDataPreview;
import org.eclnt.ccaddons.pbc.dyndata.util.UtilDynDataView;
import org.eclnt.ccaddons.pbc.sjrxml.CCSjrxmlEditor;
import org.eclnt.ccaddons.pbc.sjrxml.CCSjrxmlToolSetFormUI;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormVersionInfo;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlPersistence;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogic;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogicToolset;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.componentnodes.MENUITEMNode;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuLoad;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.util.valuemgmt.IActionListenerDelegation;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageAwarePageBean;
import org.eclnt.workplace.IWorkpageDispatcher;

@CCGenClass(expressionBase="#{d.CCSjrxmlToolSet}")
public class CCSjrxmlToolSet
extends PageBeanComponent
implements Serializable,
IWorkpageAwarePageBean {
    private IListener m_listener;
    CCMasterDetail m_masterDetail = new CCMasterDetail();
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    ISjrxmlPersistence m_persistence = SjrxmlPersistence.instance();
    String m_lastSaveStamp = "inittini";
    CCSjrxmlEditor m_editorUI;
    String m_currentCategoryId;
    String m_currentFormId;
    String m_currentDataId;
    String m_currentFormName = null;
    DynDataReaderContext m_ddrContext;
    boolean m_availableEditFormData = true;
    boolean m_availableSave = true;
    String m_searchText;
    DYNAMICCONTENTBinding m_menuHistoryContent = new DYNAMICCONTENTBinding();
    boolean m_availableVersionInfos = false;
    IWorkpageDispatcher m_dispatcher;

    public CCSjrxmlToolSet() {
        this.m_ddrContext = DynDataPreview.createContextViaCceeConfig();
        this.loadTree();
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCSjrxmlToolSet}";
    }

    public void setWorkpageDispatcher(IWorkpageDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
    }

    public void onSearchTextAction(ActionEvent event) {
        this.loadTree();
    }

    public String getSearchText() {
        return this.m_searchText;
    }

    public void setSearchText(String value) {
        this.m_searchText = value;
    }

    public boolean getAvailableEditFormData() {
        return this.m_availableEditFormData;
    }

    public boolean getAvailableSave() {
        return this.m_availableSave;
    }

    public DYNAMICCONTENTBinding getMenuHistoryContent() {
        return this.m_menuHistoryContent;
    }

    public void prepare(DynDataReaderContext ddrContext, IListener listener) {
        if (ddrContext != null) {
            this.m_ddrContext = ddrContext;
        }
        this.m_listener = listener;
    }

    public CCMasterDetail getMasterDetail() {
        return this.m_masterDetail;
    }

    public boolean getAvailableVersionInfos() {
        return this.m_availableVersionInfos;
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public void onNewFormAction(ActionEvent event) {
        this.editForm(null, null, true);
    }

    public void onImportDemoFormsAction(ActionEvent event) {
        YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitImportDemoForms", new String[0]), (String)SJRXMLLit.lit("ynmsgImportDemoForms", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

            public void reactOnYes() {
                try {
                    SjrxmlLogicToolset.importDemos();
                    CCSjrxmlToolSet.this.loadTree();
                    Statusbar.outputSuccess((String)"Demo forms were successfully imported. Check category \"ccdemos\" for viewing the demos.");
                }
                catch (Throwable t) {
                    Statusbar.outputAlert((String)t.toString(), (String)"", (String)ValueManager.getStackstraceString((Throwable)t));
                }
            }

            public void reactOnNo() {
            }
        });
    }

    public CCSjrxmlEditor getEditorUI() {
        return this.m_editorUI;
    }

    public void onSaveAction(ActionEvent event) {
        this.saveCurrentForm();
    }

    public String getTitle() {
        return this.m_currentCategoryId + " / " + this.m_currentFormId;
    }

    public String getCurrentFormId() {
        return this.m_currentFormId;
    }

    public String getCurrentFormName() {
        return this.m_currentFormName;
    }

    public void setCurrentFormName(String currentFormName) {
        this.m_currentFormName = currentFormName;
    }

    private String createSaveStamp(String sjrxml) {
        if (sjrxml == null) {
            sjrxml = "";
        }
        sjrxml = sjrxml + "/" + this.m_currentFormName;
        return sjrxml.hashCode() + "";
    }

    private void loadTree() {
        this.m_tree.getRootNode().removeAllChildNodes(true);
        List<String> cats = this.m_persistence.readCategories();
        for (String cat : cats) {
            TreeNode top = new TreeNode(this.m_tree.getRootNode(), cat, true);
            top.setStatus(1);
            List<String> forms = this.m_persistence.readFormsInCategory(cat);
            for (String form : forms) {
                TreeNode node = new TreeNode(top, form, false);
                node.setStatus(2);
                if (ValueManager.isEmpty((String)this.m_searchText) || ValueManager.checkIfStringContainsTokenizedSearchString((String)node.getText(), (String)this.m_searchText)) continue;
                node.removeNode();
            }
            if (top.getChildNodes().size() == 0) {
                top.removeNode();
                continue;
            }
            if (ValueManager.isEmpty((String)this.m_searchText)) continue;
            top.setStatus(0);
        }
    }

    protected void openCategory(String name) {
        for (Object node : this.m_tree.getRootNode().getChildNodes()) {
            TreeNode tn = (TreeNode)node;
            if (!ValueManager.checkIfStringsAreEqual((String)name, (String)tn.i_id)) continue;
            tn.setStatus(0);
            this.m_tree.selectAndFocusItem((FIXGRIDItem)tn);
            return;
        }
    }

    private void editForm(final String category, final String formId, final String dataId, final String versionInfo) {
        if (this.m_editorUI != null) {
            String sjrxml = this.m_editorUI.getCurrentXml();
            String dddxml = this.m_editorUI.getCurrentDynamicDataDefinitionXml();
            String nowStamp = this.createSaveStamp(sjrxml);
            if (ValueManager.checkIfStringsAreEqual((String)nowStamp, (String)this.m_lastSaveStamp)) {
                this.editFormExecute(category, formId, dataId, versionInfo);
            } else if (this.m_availableSave) {
                YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitUnsavedChanges", new String[0]), (String)SJRXMLLit.lit("ynmsgUnsavedChanges", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

                    public void reactOnYes() {
                        CCSjrxmlToolSet.this.editFormExecute(category, formId, dataId, versionInfo);
                    }

                    public void reactOnNo() {
                    }
                });
            } else {
                this.editFormExecute(category, formId, dataId, versionInfo);
            }
        } else {
            this.editFormExecute(category, formId, dataId, versionInfo);
        }
    }

    private void editFormExecute(String categoryId, String formId, String dataId, String versionInfo) {
        String xmlMetaData = SjrxmlLogic.readSimpleXmlEditorMetadataXml();
        final DataFormDefinition dfod = versionInfo == null ? this.m_persistence.readDataFormForEditor(formId) : this.m_persistence.readDataFormForVersion(formId, versionInfo);
        DataDynDataDefinition dddd = this.m_persistence.readDataDynData(dfod.getDddId());
        this.m_editorUI = new CCSjrxmlEditor();
        this.m_editorUI.setWorkpageDispatcher(this.m_dispatcher);
        this.m_editorUI.prepare(formId, dfod.getXml(), xmlMetaData, dataId, this.m_ddrContext, new CCSjrxmlEditor.IListener(){

            @Override
            public Object createPreviewDataObject() {
                return SjrxmlLogicToolset.createPreviewDataObjectForEditor(CCSjrxmlToolSet.this.m_ddrContext, CCSjrxmlToolSet.this.m_currentFormId);
            }

            @Override
            public String readRefreshedDynDataDefinitionXml() {
                DataDynDataDefinition dddd = CCSjrxmlToolSet.this.m_persistence.readDataDynData(dfod.getDddId());
                return dddd.getXml();
            }
        });
        this.m_availableSave = UtilDynDataView.instance().checkIfEditingIsPossible(categoryId, formId, dataId, versionInfo);
        this.m_editorUI.getDddBrowser().setAvailableStartEditor(UtilDynDataView.instance().checkIfDDEditorIsAvailableInDDBrowser(dfod, dddd));
        this.m_masterDetail.notifyMasterDetail();
        this.m_currentCategoryId = categoryId;
        this.m_currentFormId = formId;
        this.m_currentDataId = dataId;
        this.m_currentFormName = dfod.getName();
        String sjrxml = this.m_editorUI.getCurrentXml();
        String dddxml = this.m_editorUI.getCurrentDynamicDataDefinitionXml();
        this.m_lastSaveStamp = this.createSaveStamp(sjrxml);
        this.m_masterDetail.notifyMasterDetail(false);
        if (!this.m_availableSave) {
            OKPopup.createInstance((String)"", (String)SJRXMLLit.lit("msgNoEditing", new String[0]));
        }
    }

    private void editForm(DataFormDefinition dfd, String category, boolean asNew) {
        final CCSjrxmlToolSetFormUI ui = new CCSjrxmlToolSetFormUI();
        if (asNew) {
            dfd = new DataFormDefinition();
            dfd.setCategoryId(category);
        }
        ui.prepare(dfd, asNew, new CCSjrxmlToolSetFormUI.IListener(){

            @Override
            public void reactOnCancel() {
                CCSjrxmlToolSet.this.closePopup((IPageBean)ui);
            }

            @Override
            public void reactOnFormSaved(DataFormDefinition formDefinition) {
                CCSjrxmlToolSet.this.closePopup((IPageBean)ui);
                CCSjrxmlToolSet.this.loadTree();
                CCSjrxmlToolSet.this.openCategory(formDefinition.getCategoryId());
            }
        });
        ModalPopup p = this.openModalPopup((IPageBean)ui, "Create form", 0, 0, new ModalPopup.IModalPopupListener(){

            public void reactOnPopupClosedByUser() {
                CCSjrxmlToolSet.this.closePopup((IPageBean)ui);
            }
        });
        p.setLeftTopReferenceCentered();
    }

    private void removeDataForm(final DataFormDefinition dataForm) {
        YESNOPopup.createInstance((String)"", (String)SJRXMLLit.lit("ynmsgRemoveForm", dataForm.getId()), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

            public void reactOnYes() {
                CCSjrxmlToolSet.this.removeDataFormExecute(dataForm);
            }

            public void reactOnNo() {
            }
        });
    }

    private void removeDataFormExecute(DataFormDefinition dataForm) {
        SjrxmlPersistence.instance().removeDataForm(dataForm.getId());
        Statusbar.outputSuccess((String)SJRXMLLit.lit("msgFormRemoved", new String[0]));
        this.loadTree();
    }

    protected void buildHistoryMenuItems(final TreeNode treeNode) {
        try {
            if (treeNode.i_isCategory) {
                this.m_menuHistoryContent.setContentNode(null);
                return;
            }
            this.m_availableVersionInfos = false;
            List<DataFormVersionInfo> vis = this.m_persistence.readDataFormVersionInfos(treeNode.i_id);
            ArrayList<MENUITEMNode> nodes = new ArrayList<MENUITEMNode>();
            for (final DataFormVersionInfo vi : vis) {
                MENUITEMNode min = new MENUITEMNode().setText(vi.getText()).setReference(vi.getVersionInfo()).bindActionListener(new IActionListenerDelegation(){

                    public void onAction(ActionEvent event) {
                        CCSjrxmlToolSet.this.processOpenVersion(treeNode, vi);
                    }
                });
                nodes.add(min);
                this.m_availableVersionInfos = true;
            }
            this.m_menuHistoryContent.setContentNodes(nodes);
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_ERR, "Problem reading history items of: " + treeNode.i_id);
        }
    }

    protected void processOpenVersion(final TreeNode treeNode, final DataFormVersionInfo vi) {
        YESNOPopup.createInstance((String)"", (String)ResourceManager.findLiteral((String)"sjrxml", (String)"msgOpenOlderVersion"), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

            public void reactOnYes() {
                String category = ((TreeNode)treeNode.getParentNode()).i_id;
                DataFormDefinition dataForm = CCSjrxmlToolSet.this.m_persistence.readDataFormForVersion(treeNode.i_id, vi.getVersionInfo());
                CCSjrxmlToolSet.this.editForm(category, treeNode.i_id, dataForm.getDddId(), vi.getVersionInfo());
            }

            public void reactOnNo() {
            }
        });
    }

    protected void saveCurrentForm() {
        String sjrxml = this.m_editorUI.getCurrentXml();
        DataFormDefinition dataForm = this.m_persistence.readDataFormForEditor(this.m_currentFormId);
        dataForm.setXml(sjrxml);
        dataForm.setName(this.m_currentFormName);
        this.m_persistence.saveDataForm(dataForm);
        this.m_lastSaveStamp = this.createSaveStamp(sjrxml);
        Statusbar.outputSuccess((String)SJRXMLLit.lit("msgFormSaved", this.m_currentFormId));
    }

    public static interface IListener
    extends Serializable {
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        String i_id;
        boolean i_isCategory;

        public TreeNode(FIXGRIDTreeItem parentNode, String name, boolean isCategory) {
            super(parentNode);
            this.i_isCategory = false;
            this.i_isCategory = isCategory;
            this.i_id = name;
            this.setText(name);
        }

        public void onRowSelect() {
        }

        public void onRowExecute() {
            if (!this.i_isCategory) {
                String category = ((TreeNode)this.getParentNode()).i_id;
                DataFormDefinition dataForm = CCSjrxmlToolSet.this.m_persistence.readDataFormForEditor(this.i_id);
                CCSjrxmlToolSet.this.editForm(category, this.i_id, dataForm.getDddId(), null);
            }
        }

        public void onToggle() {
        }

        public void onRowPopupMenuItem(BaseActionEventPopupMenuItem event) {
            if (event instanceof BaseActionEventPopupMenuItem) {
                BaseActionEventPopupMenuItem e = event;
                if ("NEWFORM".equals(e.getCommand())) {
                    if (this.i_isCategory) {
                        CCSjrxmlToolSet.this.editForm(null, this.i_id, true);
                    } else {
                        CCSjrxmlToolSet.this.editForm(null, ((TreeNode)this.getParentNode()).i_id, true);
                    }
                } else if ("EDITFORM".equals(e.getCommand())) {
                    DataFormDefinition dataForm = CCSjrxmlToolSet.this.m_persistence.readDataFormForEditor(this.i_id);
                    if (!this.i_isCategory) {
                        CCSjrxmlToolSet.this.editForm(dataForm, this.i_id, false);
                    }
                } else if ("REMOVEFORM".equals(e.getCommand())) {
                    DataFormDefinition dataForm = CCSjrxmlToolSet.this.m_persistence.readDataFormForEditor(this.i_id);
                    CCSjrxmlToolSet.this.removeDataForm(dataForm);
                } else if ("EDITNEWESTVERSION".equals(e.getCommand())) {
                    this.onRowExecute();
                }
            }
        }

        public void onRowPopupMenuLoad(BaseActionEventPopupMenuLoad event) {
            CCSjrxmlToolSet.this.m_availableEditFormData = !this.i_isCategory;
            CCSjrxmlToolSet.this.buildHistoryMenuItems(this);
        }
    }
}

