/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataLogic;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCSjrxmlToolSetFormUI}")
public class CCSjrxmlToolSetFormUI
extends PageBean
implements Serializable {
    private IListener m_listener;
    DataFormDefinition m_formDefinition;
    boolean m_isNewForm = false;

    public String getPageName() {
        return "/org/eclnt/ccaddons/pbc/sjrxml/CCSjrxmlToolSetForm.xml";
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCSjrxmlToolSetFormUI}";
    }

    public void prepare(DataFormDefinition formDefinition, boolean isNewForm, IListener listener) {
        this.m_listener = listener;
        this.m_isNewForm = isNewForm;
        this.m_formDefinition = formDefinition;
    }

    public void onCancelAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnCancel();
        }
    }

    public DataFormDefinition getFormDefinition() {
        return this.m_formDefinition;
    }

    public void onOKAction(ActionEvent event) {
        try {
            List<String> result = DataLogic.saveFormDefinition(this.m_formDefinition, this.m_isNewForm);
            if (result.size() == 0) {
                if (this.m_listener != null) {
                    this.m_listener.reactOnFormSaved(this.m_formDefinition);
                }
            } else {
                for (String s : result) {
                    Statusbar.outputError((String)s);
                }
            }
        }
        catch (Throwable t) {
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
        }
    }

    public void onCategoryAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            IdTextSelection idts = IdTextSelection.createInstance();
            List<String> ids = DataLogic.getListOfCategories();
            Collections.sort(ids);
            for (String id : ids) {
                idts.addLine(id, id);
            }
            idts.setRenderIdColumn(false);
            idts.setCallBack(new ISetId(){

                public void setId(String id) {
                    CCSjrxmlToolSetFormUI.this.m_formDefinition.setCategoryId(id);
                }
            });
        }
    }

    public void onDataDefinitionAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            IdTextSelection idts = IdTextSelection.createInstance();
            List<String> ids = DataLogic.getListOfDataDefinitions();
            Collections.sort(ids);
            for (String id : ids) {
                idts.addLine(id, id);
            }
            idts.setRenderIdColumn(false);
            idts.setCallBack(new ISetId(){

                public void setId(String id) {
                    CCSjrxmlToolSetFormUI.this.m_formDefinition.setDddId(id);
                }
            });
        }
    }

    public static interface IListener
    extends Serializable {
        public void reactOnFormSaved(DataFormDefinition var1);

        public void reactOnCancel();
    }
}

