/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.test;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.eclnt.ccaddons.pbc.sjrxml.test.DOArticle;
import org.eclnt.ccaddons.pbc.sjrxml.test.DOCustomer;
import org.eclnt.ccaddons.pbc.sjrxml.test.DOCustomerLogo;
import org.eclnt.ccaddons.pbc.sjrxml.test.DOCustomerOrder;
import org.eclnt.ccaddons.pbc.sjrxml.test.DOCustomerOrderItem;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.file.ClassloaderReader;

public class CreateData
implements ICCEEConstants {
    static final String[] ARTICLES = new String[]{"Laptop", "Dektop", "Notebook", "USB Hub"};
    static final String[] CUSTOMERS = new String[]{"CaptainCasa", "JKarat", "EvolutionIT"};

    public static void main(String[] args) {
        AppLog.initSystemOut();
        CreateData.createArticles();
    }

    private static void readCustomers() {
        List cls = DOFWSql.query((String)"pdf", DOCustomerLogo.class, null);
        for (DOCustomerLogo cl : cls) {
            System.out.println(cl.getId());
            System.out.println(cl.getLogo());
            System.out.println(cl.getLogo().length);
        }
    }

    private static void createOrders() {
        DOCustomerOrder o = new DOCustomerOrder();
        o.setId(45011);
        o.setCustomerId(1001);
        o.setOrderDate(LocalDate.now());
        o.setTotalPriceGross(new BigDecimal(1190));
        o.setTotalPriceNet(new BigDecimal(1190));
        o.setTotalPriceVAT(new BigDecimal(190));
        DOFWSql.saveObject((String)"pdf", (Object)o);
        DOFWSql.delete((String)"pdf", DOCustomerOrderItem.class, (Object[])new Object[]{"orderId", "=", 45011});
        for (int i = 0; i < 50; ++i) {
            DOCustomerOrderItem oi = new DOCustomerOrderItem();
            oi.setOrderId(o.getId());
            oi.setItemId(i + 1);
            oi.setArticleId(4700 + i % ARTICLES.length);
            oi.setQuantity(new BigDecimal(1));
            oi.setItemPriceGross(new BigDecimal(119));
            oi.setItemPriceNet(new BigDecimal(100));
            oi.setItemPriceVAT(new BigDecimal(19));
            DOFWSql.saveObject((String)"pdf", (Object)oi);
        }
    }

    private static void createCustomers() {
        String filePath = CreateData.class.getPackage().getName().replace(".", "/") + "/testimage.png";
        byte[] logo = new ClassloaderReader(true).readFile(filePath, true);
        for (int i = 0; i < CUSTOMERS.length; ++i) {
            DOCustomer c = new DOCustomer();
            c.setId(1000 + i);
            c.setName(CUSTOMERS[i]);
            c.setStreet("Hauptstra\u00dfe 87");
            c.setTown("XYZStadt");
            c.setZipCode("47110");
            DOFWSql.saveObject((String)"pdf", (Object)c);
            DOCustomerLogo l = new DOCustomerLogo();
            l.setId(c.getId());
            l.setLogo(logo);
            DOFWSql.saveObject((String)"pdf", (Object)l);
        }
    }

    private static void createArticles() {
        DOArticle o;
        int i;
        for (i = 0; i < ARTICLES.length; ++i) {
            o = new DOArticle();
            o.setId(4700 + i);
            o.setName(ARTICLES[i]);
            o.setUnitOfMeasure("PC");
            o.setDescription("Description of " + ARTICLES[i]);
            DOFWSql.saveObject((String)"pdf", (Object)o);
        }
        for (i = 0; i < ARTICLES.length; ++i) {
            o = new DOArticle();
            o.setId(4800 + i);
            o.setName(ARTICLES[i]);
            o.setDescription("Description of " + ARTICLES[i]);
            DOFWSql.saveObject((String)"pdf", (Object)o);
        }
    }
}

