/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import org.apache.log4j.BasicConfigurator;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.ConfigureJasperLogging;
import org.eclnt.ccee.sjrxml.ISJRXMLConstants;
import org.eclnt.ccee.sjrxml.parsing.IData;
import org.eclnt.ccee.sjrxml.parsing.IDemoCreator;
import org.eclnt.ccee.sjrxml.parsing.elements.OUTPUTLAYOUTElement;
import org.eclnt.ccee.sjrxml.persistence.SJRXMLPersistence;
import org.eclnt.ccee.sjrxml.preprocess.SJRXMLPreProcess;
import org.eclnt.ccee.sjrxml.preprocess.SJRXMLPreProcessFixProperties;
import org.eclnt.ccee.sjrxml.versions.POMVersionChecker;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JRXMLGeneratorLogic
implements ICCEEConstants,
ISJRXMLConstants {
    private static String simpleXML;

    public static String getSimpleXML() {
        return simpleXML;
    }

    public byte[] exportPdfBytes(String sjrxmlId, String sjrxml, Object dataObject) {
        return this.exportBytes(sjrxmlId, sjrxml, dataObject, "PDF");
    }

    public byte[] exportHtmlBytes(String sjrxmlId, String sjrxml, Object dataObject) {
        return this.exportBytes(sjrxmlId, sjrxml, dataObject, "HTML");
    }

    public byte[] exportBytes(String sjrxmlId, String sjrxml, Object dataObject, String outputFormat) {
        try {
            if (sjrxmlId == null) {
                sjrxmlId = UniqueIdCreator.createRandomId();
            }
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - " + sjrxmlId + ", " + outputFormat);
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - POMVersionChecker.checkVersions() started");
            POMVersionChecker.checkVersions();
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - POMVersionChecker.checkVersions() done");
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - translateSJRXML started");
            TranslatedJRXMLResult translateSJRXML = this.translateSJRXML(sjrxml, dataObject);
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - translateSJRXML done");
            translateSJRXML.setId(sjrxmlId);
            AppLog.L.log(LL_INF, "Starting exportPdfBytes - export started");
            JasperPrint jp = this.generateReport(translateSJRXML.getId(), translateSJRXML.getJrxml(), dataObject);
            byte[] result = null;
            switch (outputFormat) {
                case "PDF": {
                    result = this.executeJasperExportPdf(jp);
                    break;
                }
                case "HTML": {
                    result = this.executeJasperExportHtml(jp);
                }
            }
            if (result != null) {
                AppLog.L.log(LL_INF, "Finished exportPdfBytes - export ended, size of generated content: " + result.length);
            } else {
                AppLog.L.log(LL_INF, "Finished exportPdfBytes - export ended, generated content is null");
            }
            return result;
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem creating PDF", t);
            throw new Error("Problem creating PDF", t);
        }
    }

    public JasperPrint generateReport(String jrxmlString, String refclass) throws FileNotFoundException, JRException {
        try {
            Class<?> clazz = Class.forName(refclass + "DemoCreator");
            IDemoCreator demoCreator = (IDemoCreator)clazz.newInstance();
            IData dataObject = demoCreator.createDemoDataGrids();
            return this.generateReport(jrxmlString, dataObject);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problems creating report for class: " + refclass, t);
            throw new Error("Problems creating report for class: " + refclass);
        }
    }

    public JasperPrint generateReport(String id, String jrxmlString, Object dataObject) throws FileNotFoundException, JRException {
        AppLog.L.log(LL_INF, "Starting generateReport");
        Map<String, Object> parameters = this.createParameterMapForFillReport();
        ByteArrayInputStream targetStream = null;
        JasperReport jasper = null;
        try {
            AppLog.L.log(LL_INF, "Running generateReport - Reading jrxmlString bytes started");
            targetStream = new ByteArrayInputStream(jrxmlString.getBytes("UTF-8"));
            AppLog.L.log(LL_INF, "Running generateReport - Reading jrxmlString bytes done");
        }
        catch (UnsupportedEncodingException e) {
            AppLog.L.log(LL_ERR, "Problems transferring String into stream. UTF-8", e);
            throw new Error("Problems transferring String into stream. UTF-8", e);
        }
        String bufferedSJRXML = SJRXMLPersistence.getInstance().readPersistedSJRXML(id);
        if (bufferedSJRXML == null || !bufferedSJRXML.equals(JRXMLGeneratorLogic.getSimpleXML())) {
            try {
                AppLog.L.log(LL_INF, "Running generateReport - Compiling started");
                jasper = JasperCompileManager.compileReport((InputStream)targetStream);
                AppLog.L.log(LL_INF, "Running generateReport - Compiling finished");
                AppLog.L.log(LL_INF, "Running generateReport - Saving jasper file started");
                SJRXMLPersistence.getInstance().saveReport(id, JRXMLGeneratorLogic.getSimpleXML(), jasper);
                AppLog.L.log(LL_INF, "Running generateReport - Saving jasper file done");
            }
            catch (Throwable t) {
                AppLog.L.log(LL_ERR, "Problems compiling bytes to jasper report. SJRXML id: " + id, t);
                throw new Error("Problems compiling bytes to jasper report. SJRXML id: " + id, t);
            }
        }
        try {
            AppLog.L.log(LL_INF, "Running generateReport - Reading of existing jasper compiled file");
            jasper = SJRXMLPersistence.getInstance().readPersistedJasperReport(id);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problems finding the compiled jasper file. SJRXML id: " + id, t);
            throw new Error("Problems finding the compiled jasper file. SJRXML id: " + id, t);
        }
        if (dataObject instanceof Map) {
            try {
                ArrayList maps = new ArrayList();
                HashMap<String, Object> outerMap = new HashMap<String, Object>();
                outerMap.put("data", dataObject);
                maps.add(outerMap);
                AppLog.L.log(LL_INF, "Running generateReport - Creating JRMapCollectionDataSource started");
                JRMapCollectionDataSource ds = new JRMapCollectionDataSource(maps);
                AppLog.L.log(LL_INF, "Running generateReport - Creating JRMapCollectionDataSource done");
                AppLog.L.log(LL_INF, "Finishing generateReport - Returning JasperPrint");
                return JasperFillManager.fillReport((JasperReport)jasper, parameters, (JRDataSource)ds);
            }
            catch (Throwable t) {
                AppLog.L.log(LL_ERR, "Problems creating JRMapCollectionDataSource. SJRXML id: " + id, t);
                throw new Error("Problems creating JRMapCollectionDataSource. SJRXML id: " + id, t);
            }
        }
        try {
            ArrayList<Object> data = new ArrayList<Object>();
            data.add(dataObject);
            AppLog.L.log(LL_INF, "Starting generateReport - Creating JRBeanCollectionDataSource started");
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(data);
            AppLog.L.log(LL_INF, "Starting generateReport - Creating JRBeanCollectionDataSource done");
            AppLog.L.log(LL_INF, "Finishing generateReport - Returning JasperPrint");
            return JasperFillManager.fillReport((JasperReport)jasper, parameters, (JRDataSource)ds);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problems creating JRBeanCollectionDataSource. SJRXML id: " + id, t);
            throw new Error("Problems creating JRBeanCollectionDataSource. SJRXML id: " + id, t);
        }
    }

    public JasperPrint generateReport(String jrxmlString, Object dataObject) throws FileNotFoundException, JRException {
        BasicConfigurator.configure();
        Map<String, Object> parameters = this.createParameterMapForFillReport();
        ByteArrayInputStream targetStream = null;
        try {
            targetStream = new ByteArrayInputStream(jrxmlString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Problems transferring String into stream. UTF-8", e);
        }
        JasperReport jasper = JasperCompileManager.compileReport((InputStream)targetStream);
        if (dataObject instanceof Map) {
            ArrayList maps = new ArrayList();
            HashMap<String, Object> outerMap = new HashMap<String, Object>();
            outerMap.put("data", dataObject);
            maps.add(outerMap);
            JRMapCollectionDataSource ds = new JRMapCollectionDataSource(maps);
            return JasperFillManager.fillReport((JasperReport)jasper, parameters, (JRDataSource)ds);
        }
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(dataObject);
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(data);
        return JasperFillManager.fillReport((JasperReport)jasper, parameters, (JRDataSource)ds);
    }

    protected Map<String, Object> createParameterMapForFillReport() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("net.sf.jasperreports.governor.max.pages.enabled", true);
        result.put("net.sf.jasperreports.governor.max.pages", 100);
        return result;
    }

    public TranslatedJRXMLResult translateSJRXML(String sjrxml, Object dataObject) {
        try {
            AppLog.L.log(LL_INF, "Starting translateSJRXML");
            SimpleXMLElement sjrxmlRoot = SimpleXML.parseXML((String)sjrxml);
            SimpleXMLElement preProcessedRoot = new SJRXMLPreProcessFixProperties(sjrxmlRoot, dataObject).preprocess();
            preProcessedRoot = new SJRXMLPreProcess(preProcessedRoot).preprocess();
            sjrxml = preProcessedRoot.toXML();
            OUTPUTLAYOUTElement outputLayoutElement = this.parseOutputLayoutElementXML(sjrxml);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            String jrxmlString = "";
            if (outputLayoutElement.getAttributes().size() > 0) {
                jrxmlString = outputter.outputString(outputLayoutElement.generateJRXMLDocument());
                jrxmlString = jrxmlString.replace("xmlns:xxx=", "xmlns=");
            }
            TranslatedJRXMLResult result = new TranslatedJRXMLResult("", jrxmlString, outputLayoutElement);
            AppLog.L.log(LL_INF, "Finished translateSJRXML, returning TranslatedJRXMLResult");
            return result;
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problems translating sjrxml", t);
            throw new Error("Problems translating sjrxml", t);
        }
    }

    public String createJrxmlFromSjrxml(String sjrxml) {
        TranslatedJRXMLResult translateSJRXML = this.translateSJRXML(sjrxml, null);
        return translateSJRXML.getJrxml();
    }

    public OUTPUTLAYOUTElement parseOutputLayoutElementXML(String xml) {
        simpleXML = xml;
        try {
            SimpleXMLElement outputLayoutNode = SimpleXML.parseXML((String)xml);
            return OUTPUTLAYOUTElement.generateCCXMLElement(outputLayoutNode);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problems parsing OutputLayoutElement", t);
            t.printStackTrace();
            return null;
        }
    }

    protected byte[] executeJasperExportPdf(JasperPrint jasperPrint) throws Exception {
        return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
    }

    protected byte[] executeJasperExportHtml(JasperPrint jasperPrint) throws Exception {
        StringBuffer html = new StringBuffer();
        HtmlExporter exporter = new HtmlExporter((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        final HashMap images = new HashMap();
        SimpleHtmlExporterOutput simpleHtmlExporterOutput = new SimpleHtmlExporterOutput(html);
        simpleHtmlExporterOutput.setImageHandler(new HtmlResourceHandler(){

            public void handleResource(String id, byte[] data) {
                System.err.println("id" + id);
                if (id.endsWith(".svg")) {
                    images.put(id, "data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(data));
                } else if (id.endsWith(".png")) {
                    images.put(id, "data:image/png;base64," + Base64.getEncoder().encodeToString(data));
                } else if (id.endsWith(".jpg")) {
                    images.put(id, "data:image/jpg;base64," + Base64.getEncoder().encodeToString(data));
                }
            }

            public String getResourcePath(String id) {
                return (String)images.get(id);
            }
        });
        exporter.setExporterOutput((ExporterOutput)simpleHtmlExporterOutput);
        exporter.exportReport();
        byte[] result = html.toString().getBytes("UTF-8");
        return result;
    }

    static {
        ConfigureJasperLogging.configure();
    }

    public static class TranslatedJRXMLResult {
        String sjrxmlId;
        String jrxml;
        OUTPUTLAYOUTElement outputLayoutElement;

        public TranslatedJRXMLResult(String id, String jrxml, OUTPUTLAYOUTElement outputLayoutElement) {
            this.sjrxmlId = id;
            this.jrxml = jrxml;
            this.outputLayoutElement = outputLayoutElement;
        }

        public String getId() {
            return this.sjrxmlId;
        }

        public void setId(String id) {
            this.sjrxmlId = id;
        }

        public String getJrxml() {
            return this.jrxml;
        }

        public OUTPUTLAYOUTElement getOutputLayoutElement() {
            return this.outputLayoutElement;
        }
    }
}

