/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;

public class CheckingMessages {
    static Map<Locale, ResourceBundle> s_bufferedResourceBundles = new HashMap<Locale, ResourceBundle>();
    static ILocaleAccess s_localeAccess = new DefaultLocaleAccess();

    public static void initializeLocaleAccess(ILocaleAccess localeAccess) {
        s_localeAccess = localeAccess;
    }

    public static String createMessage(String textId, Object ... dataObjects) {
        Locale l = s_localeAccess.getCurrentLocale();
        ResourceBundle rb = CheckingMessages.findResourceBundle(l);
        String message = "";
        try {
            message = MessageFormat.format(rb.getString(textId), dataObjects);
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_INF, "Problem creating Checker Error Message", t);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findResourceBundle(Locale l) {
        ResourceBundle result = s_bufferedResourceBundles.get(l);
        if (result == null) {
            Map<Locale, ResourceBundle> map = s_bufferedResourceBundles;
            synchronized (map) {
                result = s_bufferedResourceBundles.get(l);
                if (result == null) {
                    result = ResourceBundle.getBundle("org.eclnt.ccee.sjrxml.checking.literals", l);
                    s_bufferedResourceBundles.put(l, result);
                }
            }
        }
        return result;
    }

    public static interface ILocaleAccess {
        public Locale getCurrentLocale();
    }

    public static class DefaultLocaleAccess
    implements ILocaleAccess {
        @Override
        public Locale getCurrentLocale() {
            return Locale.getDefault();
        }
    }
}

