/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.elements.BarcodeTypes;
import org.eclnt.ccee.sjrxml.parsing.elements.BaseElement;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BARCODEElement
extends BaseElement {
    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public Element generateJRXMLElement(JRXMLContext context) {
        Namespace c = Namespace.getNamespace((String)"c", (String)"http://jasperreports.sourceforge.net/jasperreports/components");
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element barcode = new Element("componentElement");
        Element reportElement = new Element("reportElement");
        Element propertyY = new Element("property");
        propertyY.setAttribute("name", "com.jaspersoft.studio.unit.y");
        propertyY.setAttribute("value", "px");
        Element propertyX = new Element("property");
        propertyX.setAttribute("name", "com.jaspersoft.studio.unit.x");
        propertyX.setAttribute("value", "px");
        Element propertyHeight = new Element("property");
        propertyHeight.setAttribute("name", "com.jaspersoft.studio.unit.height");
        propertyHeight.setAttribute("value", "px");
        reportElement.addContent((Content)propertyY);
        reportElement.addContent((Content)propertyX);
        reportElement.addContent((Content)propertyHeight);
        this.fillReportElementAttributes(reportElement, context);
        reportElement.setAttribute("mode", "Opaque");
        Element code = this.m_attributes.containsKey("type") ? this.buildCodeElement(context, c, xsi, (String)this.m_attributes.get("type"), reportElement, barcode) : this.buildCodeElement(context, c, xsi, "Code39 (Extended)", reportElement, barcode);
        barcode.addContent((Content)reportElement);
        barcode.addContent((Content)code);
        return barcode;
    }

    private Element buildCodeElement(JRXMLContext context, Namespace c, Namespace xsi, String codeType, Element reportElement, Element barcode) {
        Element code = null;
        if (codeType != null && !codeType.isEmpty()) {
            if (codeType.equals(BarcodeTypes.DataMatrix.getKey()) || codeType.equals(BarcodeTypes.RoyalMailCustomer.getKey()) || codeType.equals(BarcodeTypes.EAN8.getKey()) || codeType.equals(BarcodeTypes.UPCE.getKey()) || codeType.equals(BarcodeTypes.POSTNET.getKey()) || codeType.equals(BarcodeTypes.Interleaved2Of5.getKey()) || codeType.equals(BarcodeTypes.USPSIntelligentMail.getKey())) {
                code = new Element(codeType, c);
                code.setAttribute("schemaLocation", "http://jasperreports.sourceforge.net/jasperreports/components  http://jasperreports.sourceforge.net/xsd/components.xsd", xsi);
            } else {
                code = new Element("barbecue", c);
                code.setAttribute("schemaLocation", "http://jasperreports.sourceforge.net/jasperreports/components  http://jasperreports.sourceforge.net/xsd/components.xsd", xsi);
                code.setAttribute("type", codeType);
                if (this.m_attributes.get("text") != null && this.m_attributes.get("drawText") != null) {
                    code.setAttribute("drawText", (String)this.m_attributes.get("drawText"));
                }
            }
        }
        Element codeExpression = new Element("codeExpression", c);
        String textValue = (String)this.m_attributes.get("text");
        if (ExpressionUtil.checkIfStraightExpression(textValue)) {
            codeExpression.setContent((Content)new CDATA(ExpressionUtil.parseAndBuildExpression(context, textValue)));
        } else {
            codeExpression.setContent((Content)new CDATA("\"" + textValue + "\""));
        }
        code.addContent((Content)codeExpression);
        return code;
    }
}

