/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.StylesGenerator;
import org.eclnt.ccee.sjrxml.parsing.elements.BaseElement;
import org.eclnt.ccee.sjrxml.parsing.elements.COLFOOTERElement;
import org.eclnt.ccee.sjrxml.parsing.elements.COLHEADERElement;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.GRIDFOOTERElement;
import org.eclnt.ccee.sjrxml.parsing.elements.GRIDHEADERElement;
import org.eclnt.ccee.sjrxml.parsing.elements.TEXTElement;
import org.eclnt.ccee.sjrxml.util.AutoCalculationFont;
import org.eclnt.ccee.sjrxml.util.AutoCalculationGeneral;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class GRIDCOLElement
extends BaseElement {
    @Override
    public void fillAttribute(SimpleXMLElement element, String attrName) {
        if ("height".equals(attrName)) {
            this.getAttributes().put(attrName, element.getValue(attrName));
            int pixelsInt = AutoCalculationFont.calculatePixelHeightFromElement(this.getAttributes());
            String pixels = String.valueOf(pixelsInt);
            this.getAttributes().put(attrName, pixels);
        } else if ("cellHeight".equals(attrName)) {
            this.getAttributes().put(attrName, element.getValue(attrName));
            List<IPixelPositionAccess> ppas = this.buildChildrenListForSizing();
            int pixelsInt = AutoCalculationGeneral.calculatePixelHeightFromElement(this.m_elementName, attrName, this.getAttributes(), ppas, 0);
            String pixels = String.valueOf(pixelsInt);
            this.getAttributes().put(attrName, pixels);
        } else {
            super.fillAttribute(element, attrName);
        }
    }

    @Override
    protected Set<String> findAttributesWithAutoCalculation() {
        Set<String> result = super.findAttributesWithAutoCalculation();
        result.add("cellHeight");
        return result;
    }

    @Override
    protected List<IPixelPositionAccess> buildChildrenListForSizing() {
        ArrayList<IPixelPositionAccess> ppas = new ArrayList<IPixelPositionAccess>();
        for (BaseElement ppa : this.getChildren()) {
            if ("colheader".equals(ppa.getElementName()) || "colfooter".equals(ppa.getElementName())) continue;
            ppas.add(ppa);
        }
        return ppas;
    }

    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public Element generateJRXMLElement(JRXMLContext context) {
        int counter = 0;
        Element jrColumnFooter = null;
        Namespace jr = Namespace.getNamespace((String)"jr", (String)"http://jasperreports.sourceforge.net/jasperreports/components");
        Element gridcol = new Element("column", jr);
        gridcol.setAttribute(new Attribute("width", (String)this.m_attributes.get("width")));
        if (this.m_attributes.get("forecolor") != null && ExpressionUtil.checkIfStraightExpression((String)this.m_attributes.get("forecolor"))) {
            this.setAttributeinJDOMElement(gridcol, "forecolor", context);
        }
        if (this.m_attributes.get("backcolor") != null && ExpressionUtil.checkIfStraightExpression((String)this.m_attributes.get("backcolor"))) {
            this.setAttributeinJDOMElement(gridcol, "backcolor", context);
        }
        for (BaseElement element : this.getChildren()) {
            Element childElement;
            String styleName;
            Object borderAttributes;
            if (element instanceof COLHEADERElement) {
                Element jrColumnHeader;
                ++counter;
                COLHEADERElement colHeader = (COLHEADERElement)element;
                if (this.m_attributes.get("border") != null) {
                    borderAttributes = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("border")));
                    styleName = new StylesGenerator().createBorderStyleAndReturnName("gridColBorderStyle", context, this.m_attributes, (Map<String, String>)borderAttributes);
                    jrColumnHeader = colHeader.generateJRXMLElement(context);
                    jrColumnHeader.setAttribute(new Attribute("style", styleName));
                } else {
                    jrColumnHeader = colHeader.generateJRXMLElement(context);
                }
                for (BaseElement el : element.getChildren()) {
                    childElement = el.generateJRXMLElement(context);
                    jrColumnHeader.addContent((Content)childElement);
                }
                if (!gridcol.getChildren().isEmpty() && this.getParent().getAttributeValue("suppresscolheader") == null) {
                    gridcol.setContent(0, (Content)jrColumnHeader);
                    continue;
                }
                if ("true".equals(this.getParent().getAttributeValue("suppresscolheader"))) continue;
                if (gridcol.getContentSize() > 0) {
                    gridcol.setContent(0, (Content)jrColumnHeader);
                    continue;
                }
                gridcol.addContent((Content)jrColumnHeader);
                continue;
            }
            if (element instanceof COLFOOTERElement) {
                COLFOOTERElement colFooter = (COLFOOTERElement)element;
                colFooter.m_attributes.put("rendered", this.getChildren().iterator().next().getAttributes().get("rendered"));
                jrColumnFooter = colFooter.generateJRXMLElement(context);
                if (this.m_attributes.get("border") != null) {
                    borderAttributes = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("border")));
                    styleName = new StylesGenerator().createBorderStyleAndReturnName("gridColBorderStyle", context, this.m_attributes, (Map<String, String>)borderAttributes);
                    jrColumnFooter.setAttribute(new Attribute("style", styleName));
                } else {
                    Element element2 = colFooter.generateJRXMLElement(context);
                }
                for (BaseElement el : element.getChildren()) {
                    childElement = el.generateJRXMLElement(context);
                    jrColumnFooter.addContent((Content)childElement);
                }
                if (gridcol.getChild("columnHeader", jr) != null) {
                    gridcol.addContent(1, (Content)jrColumnFooter);
                    continue;
                }
                gridcol.addContent(0, (Content)jrColumnFooter);
                continue;
            }
            gridcol.addContent(element.generateJRXMLString(context));
            if (gridcol.getChild("detailCell", jr) == null) {
                ++counter;
                this.buildDetailCellElement(context, jr, gridcol);
            }
            if (this.getParent().getAttributeValue("suppresscolheader") == null && gridcol.getChild("columnHeader", jr) == null) {
                ++counter;
                this.buildColHeaderElement(context, jr, gridcol);
                continue;
            }
            if ("true".equals(this.getParent().getAttributeValue("suppresscolheader")) || gridcol.getChild("columnHeader", jr) != null) continue;
            ++counter;
            this.buildColHeaderElement(context, jr, gridcol);
        }
        if (gridcol.getChildren().isEmpty() || gridcol.getChildren().size() == 1 && gridcol.getChild("columnHeader", jr) != null || gridcol.getChildren().size() == 1 && gridcol.getChild("columnFooter", jr) != null || gridcol.getChildren().size() == 2 && gridcol.getChild("columnHeader", jr) != null && gridcol.getChild("columnFooter", jr) != null) {
            if (this.getParent().getAttributeValue("suppresscolheader") == null && gridcol.getChild("columnHeader", jr) == null) {
                ++counter;
                this.buildColHeaderElement(context, jr, gridcol);
            }
            if (gridcol.getChild("detailCell", jr) == null) {
                ++counter;
                this.buildDetailCellElement(context, jr, gridcol);
            }
        }
        return gridcol;
    }

    private void buildDetailCellElement(JRXMLContext context, Namespace jr, Element gridcol) {
        String styleName;
        Element jrDetailCell = new Element("detailCell", jr);
        String cellHeightValue = this.getParentElement().getAttributeValue("columnsCellHeight");
        if (cellHeightValue == null) {
            cellHeightValue = (String)this.m_attributes.get("cellHeight");
        }
        if (cellHeightValue == null) {
            cellHeightValue = (String)this.m_attributes.get("height");
        }
        jrDetailCell.setAttribute(new Attribute("height", cellHeightValue));
        if (this.m_attributes.get("cellBorder") != null) {
            Map borderAttributes = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("cellBorder")));
            styleName = new StylesGenerator().createBorderStyleAndReturnName("gridCellBorderStyle", context, this.m_attributes, borderAttributes);
            jrDetailCell.setAttribute(new Attribute("style", styleName));
        }
        if (this.m_attributes.get("oddevenstyle") != null && jrDetailCell.getAttribute("style") == null) {
            Map oddEvenStyleValues = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("oddevenstyle")));
            styleName = new StylesGenerator().createOddEvenStyleAndReturnName("gridCellOddEvenStyle", context, this.m_attributes, oddEvenStyleValues);
            jrDetailCell.setAttribute(new Attribute("style", styleName));
        }
        context.setInGridCol(true);
        gridcol.addContent((Content)jrDetailCell);
        for (BaseElement elem : this.getChildren()) {
            if (elem instanceof COLHEADERElement || elem instanceof COLFOOTERElement || elem instanceof GRIDHEADERElement || elem instanceof GRIDFOOTERElement) continue;
            Element childElement = elem.generateJRXMLElement(context);
            jrDetailCell.addContent((Content)childElement);
            context.setInGridCol(false);
        }
    }

    private void buildColHeaderElement(JRXMLContext context, Namespace jr, Element gridcol) {
        Element jrColumnHeader = new Element("columnHeader", jr);
        int heightValue = this.getAutoCalculationSJRXML().calculateGRIDCOLColHeaderHeightForAllHeaderTypes(this.m_xmlElement);
        jrColumnHeader.setAttribute(new Attribute("height", "" + heightValue));
        if (this.m_attributes.get("border") != null) {
            Map borderAttributes = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("border")));
            String styleName = new StylesGenerator().createBorderStyleAndReturnName("colHeaderBorderStyle", context, this.m_attributes, borderAttributes);
            jrColumnHeader.setAttribute(new Attribute("style", styleName));
        }
        boolean isBackColorFilled = false;
        TEXTElement te = new TEXTElement();
        if (this.m_attributes.get("text") != null) {
            te.m_attributes.put("text", (String)this.m_attributes.get("text"));
        }
        if (this.m_attributes.get("x") != null) {
            te.m_attributes.put("x", (String)this.m_attributes.get("x"));
        }
        if (this.m_attributes.get("y") != null) {
            te.m_attributes.put("y", (String)this.m_attributes.get("y"));
        }
        if (this.m_attributes.get("width") != null) {
            te.m_attributes.put("width", (String)this.m_attributes.get("width"));
        }
        if (this.m_attributes.get("height") != null) {
            te.m_attributes.put("height", "" + heightValue);
        }
        if (this.m_attributes.get("forecolor") != null) {
            te.m_attributes.put("forecolor", (String)this.m_attributes.get("forecolor"));
        }
        if (this.m_attributes.get("backcolor") != null) {
            te.m_attributes.put("backcolor", (String)this.m_attributes.get("backcolor"));
            isBackColorFilled = true;
        }
        if (this.m_attributes.get("align") != null) {
            te.m_attributes.put("align", (String)this.m_attributes.get("align"));
        }
        if (this.m_attributes.get("valign") != null) {
            te.m_attributes.put("valign", (String)this.m_attributes.get("valign"));
        }
        if (this.m_attributes.get("font") != null) {
            te.m_attributes.put("font", (String)this.m_attributes.get("font"));
        }
        if (this.m_attributes.get("padding") != null) {
            te.m_attributes.put("padding", (String)this.m_attributes.get("padding"));
        }
        Element teElement = te.generateJRXMLElement(context);
        if (!isBackColorFilled) {
            teElement.getChild("reportElement").setAttribute("mode", "Transparent");
        } else {
            teElement.getChild("reportElement").setAttribute("mode", "Opaque");
        }
        jrColumnHeader.addContent((Content)teElement);
        gridcol.addContent(0, (Content)jrColumnHeader);
    }
}

