/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.util;

import java.util.Map;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.PaddingCalculation;
import org.eclnt.util.valuemgmt.ValueManager;

public class AutoCalculationFont {
    static final int FONT_DEFAULTHEIGHT = 11;
    static final float FONT_HEIGHTFACTOR = 1.25f;

    public static int calculatePixelHeightFromElement(Map<String, String> attributes) {
        String height = attributes.get("height");
        if (height == null || "auto".equals(height)) {
            String fontDefinition = attributes.get("font");
            int fontHeight = AutoCalculationFont.calculatePixelHeightFromFont(fontDefinition);
            int result = PaddingCalculation.increaseHeightByPadding(fontHeight, attributes.get("padding"));
            return result;
        }
        return DPICalculation.calculate72DpiPixelValue(height);
    }

    public static int calculatePixelHeightFromFont(String fontDefinition) {
        int fontDefinitionSize = AutoCalculationFont.findFontDefinitionSize(fontDefinition);
        float result = (float)fontDefinitionSize * 1.25f;
        return Math.round(result);
    }

    private static int findFontDefinitionSize(String fontDefinition) {
        Map m;
        String size;
        int fontSize = 11;
        if (fontDefinition != null && (size = (String)(m = ValueManager.decodeComplexValue((String)fontDefinition)).get("size")) != null) {
            fontSize = ValueManager.decodeInt((String)size, (int)fontSize);
        }
        return fontSize;
    }
}

