/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.ccee.sjrxml.util.PaddingCalculation;

public class AutoCalculationGeneral
implements IConstantsElementNames {
    static final Map<String, Integer> s_defaultWidthsPerElement = new HashMap<String, Integer>();
    static final Map<String, Integer> s_defaultHeightsPerElement = new HashMap<String, Integer>();

    public static int calculatePixelHeightFromElement(String elementName, Map<String, String> attributes, List<IPixelPositionAccess> children, int minimumPixels) {
        return AutoCalculationGeneral.calculatePixelHeightFromElement(elementName, "height", attributes, children, minimumPixels);
    }

    public static int calculatePixelHeightFromElement(String elementName, String heightAttributeName, Map<String, String> attributes, List<IPixelPositionAccess> children, int minimumPixels) {
        String height = attributes.get(heightAttributeName);
        if (height == null || "auto".equals(height)) {
            int contentHeight = AutoCalculationGeneral.calculatePixelHeightFromChildren(children);
            if (contentHeight == 0 && "height".equals(heightAttributeName) && s_defaultHeightsPerElement.containsKey(elementName)) {
                contentHeight = s_defaultHeightsPerElement.get(elementName);
            }
            int result = contentHeight;
            if (!"gridcol".equals(elementName)) {
                result = PaddingCalculation.increaseHeightByPadding(contentHeight, attributes.get("padding"));
            }
            if (result < minimumPixels) {
                result = minimumPixels;
            }
            return result;
        }
        return DPICalculation.calculate72DpiPixelValue(height);
    }

    public static int calculatePixelWidthFromElement(String elementName, Map<String, String> attributes, List<IPixelPositionAccess> children, int minimumPixels) {
        String width = attributes.get("width");
        if (width == null || "auto".equals(width)) {
            int contentWidth = AutoCalculationGeneral.calculatePixelWidthFromChildren(children);
            if (contentWidth == 0 && s_defaultWidthsPerElement.containsKey(elementName)) {
                contentWidth = s_defaultWidthsPerElement.get(elementName);
            }
            int result = contentWidth;
            if (!"gridcol".equals(elementName)) {
                result = PaddingCalculation.increaseWidthByPadding(contentWidth, attributes.get("padding"));
            }
            if (result < minimumPixels) {
                result = minimumPixels;
            }
            return result;
        }
        return DPICalculation.calculate72DpiPixelValue(width);
    }

    private static int calculatePixelHeightFromChildren(List<IPixelPositionAccess> children) {
        int result = 0;
        for (IPixelPositionAccess child : children) {
            int childResult = child.getY() + child.getHeight();
            result = Math.max(result, childResult);
        }
        return result;
    }

    private static int calculatePixelWidthFromChildren(List<IPixelPositionAccess> children) {
        int result = 0;
        for (IPixelPositionAccess child : children) {
            int childResult = child.getX() + child.getWidth();
            result = Math.max(result, childResult);
        }
        return result;
    }

    static {
        s_defaultWidthsPerElement.put("barcode", 100);
        s_defaultHeightsPerElement.put("barcode", 60);
        s_defaultWidthsPerElement.put("checkbox", 20);
        s_defaultHeightsPerElement.put("checkbox", 20);
        s_defaultWidthsPerElement.put("grid", 200);
        s_defaultHeightsPerElement.put("grid", 20);
        s_defaultWidthsPerElement.put("image", 100);
        s_defaultHeightsPerElement.put("image", 100);
        s_defaultWidthsPerElement.put("qrcode", 90);
        s_defaultHeightsPerElement.put("qrcode", 60);
        s_defaultWidthsPerElement.put("text", 100);
    }
}

