/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.util.valuemgmt.ValueManager;

public class Inset {
    static final String KEY_TOP = "top";
    static final String KEY_BOTTOM = "bottom";
    static final String KEY_LEFT = "left";
    static final String KEY_RIGHT = "right";
    static final String KEY_TOPCOMP = "Top";
    static final String KEY_BOTTOMCOMP = "Bottom";
    static final String KEY_LEFTCOMP = "Left";
    static final String KEY_RIGHTCOMP = "Right";
    int m_pixelTop = 0;
    int m_pixelBottom = 0;
    int m_pixelLeft = 0;
    int m_pixelRight = 0;
    Map<String, String> m_additionalsMap = new HashMap<String, String>();

    public Inset() {
    }

    public Inset(Inset inset) {
        if (inset != null) {
            this.m_pixelTop = inset.m_pixelTop;
            this.m_pixelBottom = inset.m_pixelBottom;
            this.m_pixelLeft = inset.m_pixelLeft;
            this.m_pixelRight = inset.m_pixelRight;
            this.m_additionalsMap.putAll(inset.m_additionalsMap);
        }
    }

    public Inset(String s) {
        if (s != null) {
            Map m = ValueManager.decodeComplexValue((String)s);
            Iterator iterator = m.keySet().iterator();
            block16: while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "top": 
                    case "Top": {
                        this.m_pixelTop = this.readPixelValueFromString(key, m);
                        continue block16;
                    }
                    case "bottom": 
                    case "Bottom": {
                        this.m_pixelBottom = this.readPixelValueFromString(key, m);
                        continue block16;
                    }
                    case "left": 
                    case "Left": {
                        this.m_pixelLeft = this.readPixelValueFromString(key, m);
                        continue block16;
                    }
                    case "right": 
                    case "Right": {
                        this.m_pixelRight = this.readPixelValueFromString(key, m);
                        continue block16;
                    }
                }
                this.m_additionalsMap.put(key, (String)m.get(key));
            }
        }
    }

    public static String convertInsetIntoPixelInset(String inset) {
        return new Inset(inset).toPixelString();
    }

    public int getPixelTop() {
        return this.m_pixelTop;
    }

    public int getPixelBottom() {
        return this.m_pixelBottom;
    }

    public int getPixelLeft() {
        return this.m_pixelLeft;
    }

    public int getPixelRight() {
        return this.m_pixelRight;
    }

    public void setPixelTop(int pixelTop) {
        this.m_pixelTop = pixelTop;
    }

    public void setPixelBottom(int pixelBottom) {
        this.m_pixelBottom = pixelBottom;
    }

    public void setPixelLeft(int pixelLeft) {
        this.m_pixelLeft = pixelLeft;
    }

    public void setPixelRight(int pixelRight) {
        this.m_pixelRight = pixelRight;
    }

    public String toPixelString() {
        HashMap<String, String> m = new HashMap<String, String>();
        if (this.m_pixelTop != 0) {
            m.put(KEY_TOP, "" + this.m_pixelTop);
        }
        if (this.m_pixelBottom != 0) {
            m.put(KEY_BOTTOM, "" + this.m_pixelBottom);
        }
        if (this.m_pixelLeft != 0) {
            m.put(KEY_LEFT, "" + this.m_pixelLeft);
        }
        if (this.m_pixelRight != 0) {
            m.put(KEY_RIGHT, "" + this.m_pixelRight);
        }
        for (String key : this.m_additionalsMap.keySet()) {
            m.put(key, this.m_additionalsMap.get(key));
        }
        String result = ValueManager.encodeComplexValue(m);
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    private int readPixelValueFromString(String key, Map<String, String> m) {
        String s = m.get(key);
        if (ValueManager.isEmpty((String)s)) {
            return 0;
        }
        return DPICalculation.calculate72DpiPixelValue(s);
    }
}

