/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdfbysjrxml.comm.client;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingInvoke;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingResult;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.valuemgmt.ValueManager;

public class PDFProcessingClient {
    String m_baseURL;
    PDFProcessingInvoke m_pdfProcessingInvoke;

    public String getBaseURL() {
        return this.m_baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.m_baseURL = baseURL;
    }

    public PDFProcessingInvoke getPdfProcessingInvoke() {
        return this.m_pdfProcessingInvoke;
    }

    public void setPdfProcessingInvoke(PDFProcessingInvoke pdfProcessingInvoke) {
        this.m_pdfProcessingInvoke = pdfProcessingInvoke;
    }

    public PDFProcessingResult invoke() {
        try {
            this.checkBasicParameters();
            String jsonBody = this.buildJsonBody();
            String responseString = this.communicate(jsonBody);
            PDFProcessingResult result = this.parseResult(responseString);
            return result;
        }
        catch (Throwable t) {
            PDFProcessingResult result = new PDFProcessingResult();
            result.setMessage(ValueManager.getStackstraceString((Throwable)t));
            result.setSuccess(false);
            return result;
        }
    }

    private PDFProcessingResult parseResult(String responseString) {
        Map resultMap = JSONUtil.unmarshalMap((String)responseString);
        PDFProcessingResult result = new PDFProcessingResult();
        String contentString = (String)resultMap.get("content");
        if (contentString != null) {
            byte[] bytes = Base64.getDecoder().decode(contentString);
            result.setContent(bytes);
        }
        result.setMessage((String)resultMap.get("message"));
        result.setSuccess((Boolean)resultMap.get("success"));
        return result;
    }

    protected String communicate(String jsonBody) throws Exception {
        URL url = new URL(this.m_baseURL + "/cccreatepdf");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.getOutputStream().write(jsonBody.getBytes("UTF-8"));
        InputStream is = con.getInputStream();
        byte[] isBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
        String responseString = new String(isBytes, "UTF-8");
        return responseString;
    }

    protected String buildJsonBody() {
        return JSONUtil.marshalSimpleObject((Object)this.m_pdfProcessingInvoke);
    }

    protected void checkBasicParameters() {
        if (this.m_baseURL == null) {
            throw new Error("baseURL is not defined");
        }
        if (this.m_pdfProcessingInvoke == null) {
            throw new Error("pdfProcessingInvoke is not defined");
        }
    }
}

